Test_RotatePushAndPull = class()

function Test_RotatePushAndPull:init()
    self.title = "rotation, push, and pull"
end

function Test_RotatePushAndPull:setup()
    self.lab = PhysicsLab()
    self.lab.drawer = ShapeDrawer()
    self.lab.drawer.drawJoints = function() end --don't draw joints
    self.attracting = true
    self.lab:makePetrieDish()
    physics.gravity(0,0)
    self.distanceUnit = WIDTH * 0.015
    self.ships = {}
    for i=1, 16 do      
        local randX = math.random(math.floor(WIDTH*0.8))+(WIDTH*0.1)
        local randY = math.random(math.floor(HEIGHT*0.8))+(HEIGHT*0.1)
        local randAngle = math.random(360)
        local newShip = self.lab:polygonAt(randX, randY, {vec2(0, self.distanceUnit*1.5), vec2(-self.distanceUnit,-self.distanceUnit), vec2(self.distanceUnit, -self.distanceUnit)})
        newShip.gravityScale = 0
        newShip.angle = randAngle
        table.insert(self.ships, newShip)
    end
    print("PhysicsLab gives you simple tools for rotating and moving bodies.\n\nYour first tap will pull the ships toward your finger, and your second tap will push them away.")
end

function Test_RotatePushAndPull:draw()
    self.lab:draw()
    for _, ship in ipairs(self.ships) do
        if ship.pullTask then
            self.lab:rotateBodyToFace(ship.pullTask.target, ship, 4) 
            ship.linearVelocity.x = 0
        elseif ship.pushTask then
            self.lab:rotateBodyToFaceAwayFrom(ship.pushTask.source, ship, 4)  
            ship.linearVelocity.x = 0
        else
            ship.angularVelocity = 0
            ship.linearVelocity = vec2(0,0)
        end 
    end
end

function Test_RotatePushAndPull:touched(touch)
    self.lab:touched(touch)
    if touch.state == BEGAN then
        for _, ship in ipairs(self.ships) do
            if self.attracting then
                self.lab:rotateBodyToFace(touch.pos, ship, 4)
                self.lab:pullBodyTowards(touch.pos, ship, 2, self.distanceUnit * 4)
            else
                self.lab:rotateBodyToFaceAwayFrom(touch.pos, ship, 4)
                self.lab:pushBodyAwayFrom(touch.pos, ship, 2, self.distanceUnit * 46)
            end
        end
        self.attracting = not self.attracting
    end
end

function Test_RotatePushAndPull:collide(contact)
    self.lab:collide(contact)
end

function Test_RotatePushAndPull:cleanup()
    self.lab:clear()
end